from keras.models import load_model
from keras.preprocessing.image import img_to_array
import numpy as np
import cv2

size = 128
Data = []
num_classes = 2

def main():

    ident = [""] * num_classes
    for line in open("whoiswho.txt", "r"):
        dirname = line.split(",")[0]
        label = line.split(",")[1]
        ident[int(label)] = dirname

    model = load_model("mymodel.h5")

    cvimg = cv2.imread("test.jpg")

    imgarray = []
    imgarray.append(img_to_array(cvimg))
    imgarray = np.array(imgarray) / 255.0
    imgarray.astype('float32')

    preds = model.predict(imgarray, batch_size=imgarray.shape[0])
    for pred in preds:
        predr = np.round(pred)
    for pre_i in np.arange(len(predr)):
        if predr[pre_i] == 1:
            hantei = ident[pre_i]
            print("This is " + hantei)


if __name__ == '__main__':
    main()
